
import 'package:flutter/foundation.dart';
import 'package:viser_remit/data/model/kyc/kyc_response_model.dart';


class ServicelistResponseModel {
  ServicelistResponseModel({
      String? status, 
      Data? data,}){
    _status = status;
    _data = data;
}

  ServicelistResponseModel.fromJson(dynamic json) {
    _status = json['status'].toString();
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _status;
  Data? _data;

  String? get status => _status;
  Data? get data => _data;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['status'] = _status;
    if (_data != null) {
      map['data'] = _data?.toJson();
    }
    return map;
  }

}

class Data {
  Data({
      List<Services>? services,}){
    _services = services;
}

  Data.fromJson(dynamic json) {
    if (json['services'] != null) {
      _services = [];
      json['services'].forEach((v) {
        _services?.add(Services.fromJson(v));
      });
    }
  }
  List<Services>? _services;

  List<Services>? get services => _services;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (_services != null) {
      map['services'] = _services?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

class Services {
  Services({
      int? id, 
      String? countryDeliveryMethodId, 
      String? formId, 
      String? name, 
      String? status, 
      String? createdAt, 
      String? updatedAt, 
      Form? form,}){
    _id = id;
    _countryDeliveryMethodId = countryDeliveryMethodId;
    _formId = formId;
    _name = name;
    _status = status;
    _createdAt = createdAt;
    _updatedAt = updatedAt;
    _form = form;
}

  Services.fromJson(dynamic json) {


    _id = json['id'];
    _countryDeliveryMethodId = json['country_delivery_method_id'] != null ? json['country_delivery_method_id'].toString() : '';
    _formId = json['form_id'].toString();
    _name = json['name'] ?? '';
    _status = json['status'] != null ? json['status'].toString() : '';
    _createdAt = json['created_at'];
    _updatedAt = json['updated_at'];
    _form = json['form'] != null ? Form.fromJson(json['form']['form_data']) : null;
  }
  int? _id;
  String? _countryDeliveryMethodId;
  String? _formId;
  String? _name;
  String? _status;
  String? _createdAt;
  String? _updatedAt;
  Form? _form;

  int? get id => _id;
  String? get countryDeliveryMethodId => _countryDeliveryMethodId;
  String? get formId => _formId;
  String? get name => _name;
  String? get status => _status;
  String? get createdAt => _createdAt;
  String? get updatedAt => _updatedAt;
  Form? get form => _form;

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = _id;
    map['country_delivery_method_id'] = _countryDeliveryMethodId;
    map['form_id'] = _formId;
    map['name'] = _name;
    map['status'] = _status;
    map['created_at'] = _createdAt;
    map['updated_at'] = _updatedAt;
    return map;
  }

}
class Form {
  List<KycFormModel>? mainList;

  Form.fromJson(dynamic json) {

    print(json);

    var map = Map.from(json).map((key, value) => MapEntry(key, value));
  

    print(map);

    try {
      List<KycFormModel>? list = map.entries.map((e) {
        // Convert 'extensions' to a String if it's a List

       

        var extensions = e.value['extensions'];
        if (extensions is List) {
          extensions = extensions.join(','); // Join the list to a comma-separated string
        }

        return KycFormModel(
          e.value['name'],
          e.value['label'],
          e.value['is_required'],
          e.value['instruction'],
          extensions, // Correct assignment
          (e.value['options'] as List).map((e) => e as String).toList(),
          e.value['type'],
          '', 
        );
      }).toList();

    
      if (list.isNotEmpty) {
        mainList = list;
      }
    } catch (e) {
      if (kDebugMode) {
        print(e.toString());
      }
    }
  }



}
